<?php
/**
 * Plugin Name: ZWPlayer Video Embed

 * Plugin URI: https://www.zwplayer.cn/
 * Description: 古腾堡区块 + 短代码双用，支持直播，本地播放，封面、静音、比例等参数设置，支持 分段播放，录制，截图，自动小窗口，画中画等功能。zwplayer支持的文件编码有：h264，h265，av1，mp3，opus 支持的协议有 点播：http-flv、ws-flv、hls、dash、http-mp4 直播：http-flv、ws-flv、hls、dash、ts、webrtc、rtsp 短代码[zwplayer url="视频地址" autoplay="true"]
 * Version:     0.2
 * Author:      zwplayer

 * Author URI: https://www.zwplayer.cn/
 */

if ( ! defined( 'ABSPATH' ) ) { exit; }

define( 'ZWP_VER', '3.2' );
define( 'ZWP_URL', plugin_dir_url( __FILE__ ) );
define( 'ZWP_PATH', plugin_dir_path( __FILE__ ) );

/* ---------- 注册脚本 ---------- */
add_action( 'init', 'zwp_register_assets' );
function zwp_register_assets() {
    wp_register_script(
        'zwplayer-js',
        ZWP_URL . 'assets/zwplayer/zwplayer.js',
        [],
        ZWP_VER,
        true
    );
}

/* ---------- 短代码处理 ---------- */
add_shortcode( 'zwplayer', 'zwp_shortcode_handler' );
function zwp_shortcode_handler( $atts ) {
    $atts = shortcode_atts( [
        'url'      => '',
        'poster'   => '',
        'autoplay' => 'false',
        'localPlayback' => 'false',
        'isLive' => 'false',
         'autoSmallWindow' => 'true',
        'recordButton' => 'true',
        'segmentButton' => 'true',
        'disableMutedConfirm' => 'true',
         'snapshotButton' => 'true',
        'muted'    => 'false',
        'ratio'    => '16:9',
    ], $atts, 'zwplayer' );

    if ( empty( $atts['url'] ) ) {
        return '<!-- ZWPlayer: 缺少视频地址 -->';
    }

    $uid  = 'zwplayer_' . uniqid();
    $info = [
        'playerElm' => $uid,
        'url'       => esc_attr( $atts['url'] ),
        'poster'    => esc_attr( $atts['poster'] ),
        'autoplay'  => $atts['autoplay'] === 'true',
        'localPlayback'  => $atts['localPlayback'] === 'true',
        'isLive'  => $atts['isLive'] === 'true',
        'muted'     => $atts['muted'] === 'true',
        'fluid'     => true,
        'autoSmallWindow'     => true,
        'speedButton'     => true,
        'optionButton'     => true,
        'recordButton'     => true,
        'segmentButton'     => true,
        'snapshotButton'     => true,
        'disableMutedConfirm'     => true,
        'ratio'     => esc_attr( $atts['ratio'] ),
    ];

    wp_enqueue_script( 'zwplayer-js' );

    ob_start();
    ?>
    <div id="<?php echo $uid; ?>" style="max-width:800px;margin:0 auto;"></div>
    <script>
    document.addEventListener("DOMContentLoaded", function(){
        new ZWPlayer(<?php echo wp_json_encode( $info ); ?>);
    });
    </script>
    <?php
    return ob_get_clean();
}

/* ---------- 古腾堡区块 ---------- */
//add_action( 'init', 'zwp_register_block' );
//function zwp_register_block() {
//    wp_register_script(
//        'zwp-block-js',
//        ZWP_URL . 'assets/block.js',
//        [ 'wp-blocks', 'wp-element', 'wp-block-editor', 'wp-components', 'wp-i18n' ],
//        ZWP_VER,
//        true
//    );
//
//    register_block_type( ZWP_PATH . 'build', [
//        'editor_script'   => 'zwp-block-js',
//        'render_callback' => 'zwp_block_render',
//        'category'        => 'media',
//        'keywords'        => [ 'zwplayer', 'video', '播放器' ],
//        'supports'        => [ 'html' => false ] // 关键：不验 HTML，零验证错误
//    ] );
//}
 

/* ---------- ① 区块脚本：只进编辑器 ---------- */
add_action( 'enqueue_block_editor_assets', 'zwp_enqueue_block_editor' );
function zwp_enqueue_block_editor() {
    wp_register_script(
        'zwp-block-js',
        plugin_dir_url( __FILE__ ) . 'assets/block.js',
        [ 'wp-blocks', 'wp-element', 'wp-block-editor', 'wp-components', 'wp-i18n' ],
        filemtime( plugin_dir_path( __FILE__ ) . 'assets/block.js' ),
        true
    );
    wp_enqueue_script( 'zwp-block-js' );
    wp_enqueue_script( 'zwplayer-js' );   // 后台也要播放器
}

/* ---------- ② 区块注册：仍需 init ---------- */
 add_action( 'init', 'zwp_register_block' );
function zwp_register_block() {
    register_block_type( 'zwp/video', [          // 只用逻辑名，不指文件夹
        'editor_script'   => 'zwp-block-js',
        'render_callback' => 'zwp_block_render',
        'category'        => 'media',
        'keywords'        => [ 'zwplayer', 'video', '播放器' ],
        'supports'        => [ 'html' => false ],
    ] );
}

/* ---------- ③ 前端排队：短代码需要 ---------- */
add_action( 'wp_enqueue_scripts', 'zwp_enqueue_frontend' );
function zwp_enqueue_frontend() {
    wp_register_script( 'zwplayer-js', plugin_dir_url( __FILE__ ) . 'assets/zwplayer/zwplayer.js', [], ZWP_VER, true );
}

/* ---------- 区块渲染 ---------- */
function zwp_block_render( $atts ) {
    return zwp_shortcode_handler( [
        'url'      => $atts['url']      ?? '',
        'poster'   => $atts['poster']   ?? '',
         'isLive' => ( $atts['isLive'] ?? false ) ? 'true' : 'false',
        'autoplay' => ( $atts['autoplay'] ?? false ) ? 'true' : 'false',
        'localPlayback' => ( $atts['localPlayback'] ?? false ) ? 'true' : 'false',
        'muted'    => ( $atts['muted']    ?? false ) ? 'true' : 'false',
        'ratio'    => $atts['ratio']    ?? '16:9',
    ] );
}

/* ---------- 经典编辑器按钮 ---------- */
add_action( 'media_buttons', 'zwp_classic_btn' );
function zwp_classic_btn() {
    echo '<button type="button" class="button" onclick="';
    echo "var url=prompt('视频地址：'); if(url){wp.media.editor.insert('[zwplayer url=\"'+url+'\"]');}";
    echo '">插入 ZWPlayer</button>';
}

//add_action( 'admin_head', function () {
//    $loaded = wp_script_is( 'zwp-block-js', 'enqueued' ) ? 'YES' : 'NO';
//    echo '<div style="position:fixed;top:0;left:0;background:#007cba;color:#fff;padding:4px 12px;z-index:9999;">block.js 排队：' . $loaded . '</div>';
//} );