// assets/block.js  完整纯 JS 版（可焦点外壳 + 永久可改文本框）
const { registerBlockType } = wp.blocks;
const { InspectorControls, useBlockProps } = wp.blockEditor;
const { PanelBody, TextControl, ToggleControl } = wp.components;
const { createElement: el, Fragment } = wp.element;

registerBlockType('zwp/video', {
    title: 'ZWPlayer 视频',
    icon: 'media-video',
    category: 'media',
    keywords: ['zwplayer', 'video', '播放器'],
    attributes: {
        url: { type: 'string', default: '' },
        isLive: { type: 'boolean', default: false },
        autoplay: { type: 'boolean', default: false },
        ratio: { type: 'string', default: '16:9' },
        poster: { type: 'string', default: '' },
        muted: { type: 'boolean', default: false },
        localPlayback: { type: 'boolean', default: false },
    },

    edit: function (props) {
        const { url, isLive,autoplay, ratio, poster, muted,localPlayback } = props.attributes;
        const { setAttributes } = props;

        /* 可焦点外壳：点击即选中区块 */
        const blockProps = useBlockProps({
            tabIndex: 0,
            onClick: () => {},
            style: {
                padding: '10px',
                outline: 'none',
                background: url ? '#e8f5e9' : '#f0f0f0',
                border: '1px solid #4caf50'
            }
        });

        return el('div', blockProps,
            el(Fragment, {},
                /* 右侧设置面板 */
                el(InspectorControls, {},
                    el(PanelBody, { title: '播放器设置', initialOpen: true },
                        el(TextControl, { label: '视频地址', value: url, onChange: (v) => setAttributes({ url: v }) }),
                        el(ToggleControl, { label: '直播流', checked: isLive, onChange: (v) => setAttributes({ isLive: v }) }),
                        el(TextControl, { label: '封面图地址', value: poster, onChange: (v) => setAttributes({ poster: v }) }),
                        el(ToggleControl, { label: '自动播放', checked: autoplay, onChange: (v) => setAttributes({ autoplay: v }) }),
                        el(ToggleControl, { label: '本地播放', checked: localPlayback, onChange: (v) => setAttributes({ localPlayback: v }) }),
                        el(ToggleControl, { label: '静音', checked: muted, onChange: (v) => setAttributes({ muted: v }) }),
                        el(TextControl, { label: '比例', value: ratio, onChange: (v) => setAttributes({ ratio: v }) })
                    )
                ),

                /* 永久可改文本框 */
                el('div', { style: { padding: '30px', textAlign: 'center' } },
                    el('label', {}, '视频地址'), el('br'),
                    el('input', {
                        type: 'text',
                        value: url,
                        placeholder: '点击即可修改地址',
                        style: { width: '100%', fontSize: '16px', padding: '8px' },
                        onChange: function (e) { setAttributes({ url: e.target.value }); }
                    }),
                    url && el('br'),
                    url && el('small', { style: { color: '#388e3c' } }, '前端将显示播放器')
                )
            )
        );
    },

    save: () => null   // 动态区块，前端由 PHP 渲染
});